<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */

$this->title = 'My Yii Application';
?>
<section class="content">
    <h2>Страны</h2>
    <div class="countries">
        <?php foreach ($countries as $country): ?>
            <a class="country-link" href="<?= \yii\helpers\Url::to(['country/view', 'id' => $country->id]) ?>">
                <div class="country-card bg">
            <div class="country-name">
                <img src="<?= Yii::getAlias('@web') ?>/imgs/<?= $country->flag ?>" alt="<?= Html::encode($country->name) ?>">
                <h3><?= Html::encode($country->name) ?></h3>
            </div>
        </div></a>
        <?php endforeach; ?>
    </div>
</section>

<section class="content">
    <div class="travelling-about">
        <img src="imgs/photo2.jpg" alt="Travel Image" class="travelling-image">
        <div class="travelling-about-info">
            <h3 class="travelling-about">О компании</h3>
            <p>
                Мы создаем не просто туры, а живые эмоции, помогая вам открывать самые удивительные уголки планеты. С 2010 года наша команда профессиональных тревел-экспертов превращает мечты в реальность, предлагая уникальные маршруты, продуманные до мелочей.

                Почему выбирают нас?
                Авторские программы – только проверенные локации и небанальные впечатления.
                Индивидуальный подход – путешествуйте с комфортом, будь то роскошный отдых или бюджетный трип.
                Надежность – работаем с лучшими отелями, гидами и авиакомпаниями.
                Страсть к приключениям – мы сами влюблены в каждую страну, которую предлагаем!

                От Парижа до Токио, от ледников Исландии до пляжей Лос-Анджелеса – с нами мир становится ближе. Давайте исследовать его вместе!
            </p>

        </div>
    </div>
</section>

<section class="content">
    <h2>Популярные туры</h2>
    <div class="tours">

        <div class="tour">
            <img class="tour-image" src="imgs/beach.jpg">
            <div class="tour-info">
                <h3 class="tour-title">Заголовок</h3>
                <p class="tour-text">10 Дней</p>
            </div>
            <div class="tour-more">
                <p>Стоимость: $</p>
                <a class="tour-link" href=""><button class="tour-button">Подробнее</button></a>
            </div>
        </div>
        <div class="tour">
            <img class="tour-image" src="imgs/beach.jpg">
            <div class="tour-info">
                <h3 class="tour-title">Заголовок</h3>
                <p class="tour-text">10 Дней</p>
            </div>
            <div class="tour-more">
                <p>Стоимость: $</p>
                <a class="tour-link" href=""><button class="tour-button">Подробнее</button></a>
            </div>
        </div>
        <div class="tour">
            <img class="tour-image" src="imgs/beach.jpg">
            <div class="tour-info">
                <h3 class="tour-title">Заголовок</h3>
                <p class="tour-text">10 Дней</p>
            </div>
            <div class="tour-more">
                <p>Стоимость: $</p>
                <a class="tour-link" href=""><button class="tour-button">Подробнее</button></a>
            </div>
        </div>
    </div>



</section>

<section class="content">

    <form class="feedback-form" action="tour_request.php">
        <h2>Хотите помощь в подборе тура?</h2>
        <input type="text" id="firstname" name="firstname" placeholder="Имя">
        <input type="tel" id="phone" name="phone" placeholder="Номер телефона">
        <input type="text" id="tour" name="tour" placeholder="Тур">
        <textarea name="application_text" id="application_text" placeholder="Обращение"></textarea>
        <button type="submit">Отправить</button>
    </form>
</section>
