<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;
use yii\helpers\Url;
AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body class="d-flex flex-column h-100">
<?php $this->beginBody() ?>


<div class="header">

    <nav class="navbar">
        <div class="navbar-logo ">
            <img class="" src="<?= Url::to('@web/imgs/logo2.png') ?>" alt="Логотип">
            <h5>HighFly</h5>
        </div>
        <div class="navbar-menu">

            <a class="navbar-link" href="<?= Url::to(['site/index']) ?>">Главная</a>
            <a class="navbar-link" href="<?= Url::to(['country/alltours']) ?>">Туры</a>
            <a class="navbar-link" href="<?= Url::to(['site/about']) ?>">О нас</a>
            <?php if (!Yii::$app->user->isGuest): ?>
            <a class="navbar-link" href="<?= Url::to(['site/profile']) ?>">Профиль</a>
            <?php endif; ?>
        </div>
        <div class="navbar-info">
            <?php if (Yii::$app->user->isGuest): ?>
                <h6>
                    <a href="<?= Url::to(['site/login']) ?>">Войти</a> /
                    <a href="<?= Url::to(['site/signup']) ?>">Регистрация</a>
                </h6>
            <?php else: ?>
                <h6>
                    <?= Html::beginForm(['/site/logout'], 'post')
                    . Html::submitButton(
                        'Выйти (' . Html::encode(Yii::$app->user->identity->username) . ')',
                        ['class' => 'btn btn-lnk logout', 'style' => 'color:#black; text-decoration:underline;']
                    )
                    . Html::endForm()
                    ?>
                </h6>
            <?php endif; ?>
        </div>
    </nav>
    <?php
    $isProfilePage = (Yii::$app->controller->id === 'site' && Yii::$app->controller->action->id === 'profile');
    ?>
    <?php if (!$isProfilePage): ?>
    <div class="header-content">
        <div class="header-info">
            <h3>Мечтаете об отпуске? Мы сделаем его реальностью!</h3>
            <p>Все виды туров: пляжный отдых, активные приключения, экскурсии.
                Ваш идеальный отдых — всего в одном клике!</p>
            <a style="text-decoration: none" href="<?= Url::to(['country/alltours']) ?>" ><button class="header-info-button">Смотреть туры</button></a>
        </div>

        <?php endif; ?>
<!--        <div class="header-cards">-->
<!--            <div class="header-card beach">-->
<!--                <img src="--><?php //= Url::to('@web/css/imgs/beach.jpg') ?><!--" alt="Beach">-->
<!--                <div class="header-card-info">-->
<!--                    <h3>Рай на песке — отдых на лучших пляжах!</h3>-->
<!--                    <p>Наслаждайтесь белоснежным песком и теплым морем. Спокойствие или активные водные виды спорта — для каждого найдется идеальный отдых.</p>-->
<!--                </div>-->
<!--            </div>-->
<!---->
<!--            <div class="header-card nature">-->
<!--                <img src="--><?php //= Url::to('@web/css/imgs/nature.jpg') ?><!--" alt="Nature">-->
<!--                <div class="header-card-info">-->
<!--                    <h3>Очарование природы — отдых в сердце дикой природы!</h3>-->
<!--                    <p>Забудьте о городской суете и отправляйтесь на встречи с природой. Великолепные леса, озера и водопады ждут вас, чтобы подарить спокойствие и гармонию.</p>-->
<!--                </div>-->
<!--            </div>-->
<!---->
<!--            <div class="header-card mountains">-->
<!--                <img src="--><?php //= Url::to('@web/css/imgs/mountains2.jpg') ?><!--" alt="Mountains">-->
<!--                <div class="header-card-info">-->
<!--                    <h3>Высокие вершины — приключения в горах!</h3>-->
<!--                    <p>Насладитесь захватывающими пейзажами и активным отдыхом в горах. Пешие походы, горные приключения и свежий воздух — для тех, кто готов к новым вершинам!</p>-->
<!--                </div>-->
<!--            </div>-->
<!--        </div>-->
    </div>
</div>



        <?php if (!empty($this->params['breadcrumbs'])): ?>
            <?= Breadcrumbs::widget(['links' => $this->params['breadcrumbs']]) ?>
        <?php endif ?>
        <?= Alert::widget() ?>
        <?= $content ?>




<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
