<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "tour".
 *
 * @property int $id
 * @property string $name
 * @property int|null $country_id
 * @property string|null $city
 * @property string $image
 * @property int|null $days
 * @property int $price
 *
 * @property Country $country
 * @property TourRequest[] $tourRequests
 */
class Tour extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tour';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'image', 'price'], 'required'],
            [['country_id', 'days', 'price'], 'integer'],
            [['image'], 'string'],
            [['name'], 'string', 'max' => 255],
            [['city'], 'string', 'max' => 100],
            [['country_id'], 'exist', 'skipOnError' => true, 'targetClass' => Country::class, 'targetAttribute' => ['country_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'country_id' => 'Country ID',
            'city' => 'City',
            'image' => 'Image',
            'days' => 'Days',
            'price' => 'Price',
        ];
    }

    /**
     * Gets query for [[Country]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCountry()
    {
        return $this->hasOne(Country::class, ['id' => 'country_id']);
    }

    /**
     * Gets query for [[TourRequests]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getTourRequests()
    {
        return $this->hasMany(TourRequest::class, ['tour_id' => 'id']);
    }
}
