<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use app\models\Tour;

class TourController extends Controller
{
    public function actionView($id)
    {
        $tour = Tour::findOne($id);
        if (!$tour) {
            throw new NotFoundHttpException('Тур не найден.');
        }

        return $this->render('view', ['tour' => $tour]);
    }

    public function actionTour()
    {
        $tour = Tour::findAll();
        if (!$tour) {
            throw new NotFoundHttpException('Тур не найден.');
        }

        return $this->render('tour', ['tour' => $tour]);
    }

    public function actionAllTours()
    {
        $tours = Tour::find()->all();

        return $this->render('alltours', [
            'tours' => $tours,
        ]);
    }

}