<?php

namespace app\controllers;

use app\models\Tour;
use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use app\models\Country;

class CountryController extends Controller
{
    // Список стран
    public function actionIndex()
    {
        $countries = Country::find()->all();
        return $this->render('index', ['countries' => $countries]);
    }

    // Туры по стране
    public function actionView($id)
    {
        $country = Country::findOne($id);
        if (!$country) {
            throw new NotFoundHttpException('Страна не найдена.');
        }

        $tours = $country->tours;
        return $this->render('view', [
            'country' => $country,
            'tours' => $tours,
        ]);
    }

    public function actionTourview($id)
    {
        $tours = Tour::findOne($id);
        if (!$tours) {
            throw new NotFoundHttpException('Тур не найден');
        }
        return $this->render('tourview', ['tours' => $tours]);
    }

    public function actionAlltours()
    {

        $tours = Tour::find()->all();

        return $this->render('alltours', [
            'tours' => $tours,
        ]);
    }
}
